<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaksis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained(
                table: 'users',
                indexName: 'transaksi_user_id'
            )->onDelete('cascade');
            $table->foreignId('member_id')->constrained(
                table: 'members',
                indexName: 'transaksi_member_id'
            )->onDelete('cascade');
            $table->string('kd_transaksi')->unique();
            $table->double('jumlah');
            $table->double('diskon');
            $table->double('ongkir');
            $table->double('total');
            $table->double('dibayar');
            $table->enum('sts_transaksi', ['Y', 'N', 'T']);
            $table->enum('via_bayar', ['T', 'K']);
            $table->enum('jns_transaksi', ['ON', 'OFF']);
            $table->enum('sts_antar', ['N', 'Y']);
            $table->string('ip_address');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaksis');
    }
};
